SELECT TSystem.triggers__all__enable();
--/*
DROP TABLE IF EXISTS TWawi.beleg_k__lieferscheinv CASCADE;
DROP TABLE IF EXISTS TWawi.beleg_p__lieferscheinv CASCADE;
--*/

--

-- Kopf

--
CREATE TABLE TWawi.beleg_k__lieferscheinv (
    kx_refbeleg                     VARCHAR(75),
    kx_ad_krzl                      VARCHAR(30) NOT NULL REFERENCES adressen_keys ON UPDATE CASCADE,
    kx_ad_krzf                      VARCHAR(30) NOT NULL REFERENCES adressen_keys ON UPDATE CASCADE,
    kx_gewicht                      NUMERIC(12,4),
    klv_fakturiert                  BOOL NOT NULL DEFAULT FALSE            -- beld_verbucht        -- Lieferschein verrechnet
 ) INHERITS (TSystem_Wawi.beleg_k, TSystem_Wawi.beleg_k__extend_wawi_ansprechpartner, TSystem_Wawi.beleg_x__allgfields, TSystem_Wawi.beleg_k__versand, TSystem_Wawi.beleg_k__export_zoll);

-- Constraints und Trigger
 SELECT  TSystem_Wawi.beleg_k__trigger__all__create('twawi','beleg_k__lieferscheinv');
 SELECT  TSystem_Wawi.beleg_k__constraints__all__create('twawi','beleg_k__lieferscheinv');

/*
*/

-- Trigger
 CREATE OR REPLACE FUNCTION TWawi.beleg_k__lieferscheinv__b_50_u__definitiv_fakturiert() RETURNS TRIGGER AS $$
   DECLARE flag BOOLEAN;
   BEGIN
      /*Wenn sich Fakturiert-Status klv_fakturiert(beld_verbucht) im Lieferschein ändert, setzen wir den definitiv Status ggf. um.
        Sind alle Lagerabgänge nicht verrechenbar (z.Bsp. Konsignationslager), wird der Lieferschein autom. fakturiert gesetzt,
        damit er aus Assistenten raus und nicht "offen" ist. Wenn es keine einzige Rechnung auf den Lieferschein gab
        und der trotzdem fakturiert ist, darf er nicht definitiv gesetzt werden, da wir wahrscheinlich noch Sachen anhängen wolle. */
      IF (new.klv_fakturiert) AND (NOT new.k_definitiv) THEN
        SELECT EXISTS (
                SELECT true FROM TWawi.beleg_p__lieferscheinv lv_p JOIN twawi.beleg_p__rechnunge ON p_id = prv_lieferscheinv_p_id
                        WHERE lv_p.p_k_id = new.k_id ) INTO flag;
        new.k_definitiv := flag;
      END IF;
      --Wenn definitiv Status gesetzt wurde, pruefen wir, ob es überhaupt verrechenbare Positionen gibt. Falls nein, fakturiert setzen.
      IF (new.k_definitiv) AND (NOT old.k_definitiv) THEN
        SELECT NOT EXISTS(SELECT true FROM TWawi.beleg_p__lieferscheinv WHERE p_k_id = new.k_id AND NOT p_done AND NOT p_storno) INTO flag;
        new.klv_fakturiert := flag;
      END IF;
     RETURN new;
   END $$ LANGUAGE plpgsql;
   --
   CREATE TRIGGER beleg_k__b_50_u__lieferscheinv__definitiv_fakturiert
    BEFORE UPDATE
    OF k_definitiv, klv_fakturiert
    ON TWawi.beleg_k__lieferscheinv
    FOR EACH ROW
    EXECUTE PROCEDURE TWawi.beleg_k__lieferscheinv__b_50_u__definitiv_fakturiert();


-- Automatisch bei Lieferscheinen die Eigenschaft "Gelangensbestätigung: Unterschrift erhalten" ja/nein anlegen, wenn Gedruckt-Status gesetzt wird. #4512
 CREATE OR REPLACE FUNCTION TWawi.beleg_k__lieferscheinv__a_50_u__print() RETURNS TRIGGER AS $$
    BEGIN
      -- Automatisch bei Lieferscheinen die Eigenschaft "Gelangensbestätigung: Unterschrift erhalten" ja/nein anlegen, wenn Gedruckt-Status gesetzt wird. #4512
      IF TSystem.Settings__GetBool('LFSAutoRecnoGelangensbestaetigung') THEN -- Der Kunde ist EU-Exporteur, Flag für Gelangsbestätigung
          IF (EXISTS(SELECT TRUE FROM adk1 JOIN adressen_view ON a1_krz = adk_ad_krz WHERE ad_krz = new.beld_krzrechnung AND a1_euexport)) THEN
            PERFORM TRecnoParam.Set('System.Gelangensbestätigung', new.dbrid, False);
          END IF;
       END IF;
     --
     IF TSystem.Settings__GetBool('OnLiefschPrint_SetBelpTermin') THEN -- Datum Warenausgang bei Lieferschein gedruckt setzen
         UPDATE TWawi.beleg_p__lieferscheinv SET plv_datum_warenausgang = IfThen(new.k_print, current_date, null)
                WHERE p_k_id = new.k_id
                      AND plv_datum_warenausgang IS DISTINCT FROM         IfThen(new.k_print, current_date, null);
       END IF;
      --
      RETURN new;
    END $$ LANGUAGE plpgsql;
   --
   CREATE TRIGGER beleg_k__a_50_u__lieferscheinv__print
    AFTER UPDATE
    OF k_print
    ON TWawi.beleg_k__lieferscheinv
    FOR EACH ROW
    EXECUTE PROCEDURE TWawi.beleg_k__lieferscheinv__a_50_u__print();
--
-- TODO FUNCTION belegdokument__a_u() RETURNS TRIGGER -- Adressen im Kopf aendern, Positionen umschreiben, wo die Adresse vorkam.(Bei Lieferschein wegen einer Lieferung und unterschiedlichen Rechnungsempfaengern)
-- Position

--
CREATE TABLE TWawi.beleg_p__lieferscheinv (
  -- Verknüpfungen
  plv_verkauf_p_id                  INTEGER REFERENCES auftg,               -- Bezug zur Vorgänger-Position im Verkauf
  plv_warenausgang_datum            DATE,                                   -- belp_termin
  plv_mengef_gme			        NUMERIC(20,8), -- DEFAULT 0?  >> Grundtrigger beleg_p__b_220_iu__menge__uf
  -- px_l_iso                          VARCHAR(5)  REFERENCES laender ON UPDATE CASCADE, -- Ursprungsland
  px_an_nr                          VARCHAR(50),
  px_gewicht                        NUMERIC(12,4),

  -- TODO Vorgänger Klärung. Nur bei Kopieren in Verwendung?
        belp_vorgaenger               INTEGER , --TODO REFERENCES belegpos ON UPDATE CASCADE ON DELETE SET NULL,  -- KILL?             -- Position stammt aus dieser Vorgängerposition, falls aus Beleg übernommen. Sonst Vorgänger = w_wen, ld_id, ag_id etc ....
        belp_l_nr                     INTEGER REFERENCES lifsch,              -- KILL schon zuvor nicht mehr in Verwendung. Bezug zur Vorgänger-Position im Warenausgang
  belp_ab_ix                    INTEGER REFERENCES abk,                 -- Bezug zu einer ABK
  belp_a2_id                    INTEGER REFERENCES ab2,                 -- Bezug zu einem Arbeitsgang (ist neu)
  belp_q_nr                     INTEGER REFERENCES qab                  -- Bezug zu QAB (z.Bsp. bei Retourelieferschein)

 ) INHERITS (TSystem_Wawi.beleg_p, TSystem_Wawi.beleg_p__art_menge, TSystem_Wawi.beleg_p__extend__bstat, TSystem_Wawi.beleg_p__extend__wawi__adk, TSystem_Wawi.beleg_p__extend__adress_referenz);
-- Constraints und Trigger
 SELECT  TSystem_Wawi.beleg_p__constraints__all__create('twawi','beleg_p__lieferscheinv', 'twawi','beleg_k__lieferscheinv');
 SELECT  TSystem_Wawi.beleg_p__trigger__all__create('twawi','beleg_p__lieferscheinv');


-- Trigger
 CREATE OR REPLACE FUNCTION TWawi.beleg_p__lieferscheinv__b_500_iu__mengef() RETURNS TRIGGER AS $$
  BEGIN
   -- Erledigt Status setzen, wenn übernommene Menge >= Menge und wir überhaupt ne Menge haben.
   -- Aber nur bei Änderung der fakturierten Mengen, damit man das zur Not auch händisch setzen kann.
   -- Zumachen geht automatisch, aufmachen nur haendisch oder per Rueckfrage bei Aenderung Belzeil in Faktura.
   new.p_done := ROUND( COALESCE( new.plv_mengef_gme, 0 ) ,2 ) >= ROUND( COALESCE( new.p_menge_gme, 0 ),2 ) AND (new.p_menge_gme <> 0);
   --
   RETURN new;
  END $$ LANGUAGE plpgsql;
  --
  CREATE TRIGGER b_500_iu__lieferscheinv__mengef
    BEFORE INSERT OR UPDATE
    OF plv_mengef_gme
    ON TWawi.beleg_p__lieferscheinv
    FOR EACH ROW
    EXECUTE PROCEDURE TWawi.beleg_p__lieferscheinv__b_500_iu__mengef();
 -- Externen Text an Rechnungspositionen weitergeben, wenn dort noch nicht geändert und nicht definitv. Ansonsten Meldung.
 CREATE OR REPLACE FUNCTION TWawi.beleg_p__lieferscheinv__a_700_u__p_txt_to_rechnungv() RETURNS TRIGGER AS $$
  DECLARE infotxt TEXT;
  BEGIN -- WHEN

    -- Meldung für nicht veränderbare Rechnungspositionen, bei denen der externe Text schon unterschiedlich ist oder das Dokument definitiv.
    IF EXISTS(SELECT true FROM TWawi.beleg_p__rechnungv JOIN TWawi.beleg_k__rechnungv ON k_id = p_k_id
                WHERE
                 pre_lieferschein_p_id = new.p_id
                 AND p_txt IS DISTINCT FROM new.p_txt
                 AND k_definitiv)
       THEN
        infotxt := lang_text(16340) || E'\n\n' || lang_text(379) || E':\n' || -- Der Dokumenttext im Folgedokument wurde nicht angepasst ... Faktura: ...
                    -- begin concat
                    (SELECT array_to_string(ARRAY( -- Stringliste aller Rechnungspostionen
                        SELECT k_code || ' ' || k_nummer || ' ' || lang_text(164) || ' ' || p_pos
                        FROM TWawi.beleg_p__rechnungv JOIN TWawi.beleg_k__rechnungv ON k_id = p_k_id
                        WHERE pre_lieferschein_p_id = new.p_id
                          AND p_txt IS DISTINCT FROM new.p_txt -- Ziel soll geändert werden
                          AND k_definitiv -- war aber vorher abweichend
                        ORDER BY k_code, k_nummer, p_pos
                        ), E'\n'));
                    -- End Concat
        IF infotxt IS NOT NULL THEN
            PERFORM PRODAT_TEXT(infotxt);
        END IF;
        --
     END IF;

    -- Rechnungspositionen, die automatisch synchron gehalten werden.
    UPDATE Wawi.beleg_p__rechnungv SET
      p_txt = new.p_txt,
      p_txt_rtf = new.p_txt_rtf
    FROM belkopf
    WHERE k_id = p_k_id
      AND pre_lieferschein_p_id = new.p_id
      AND NOT k_definitiv
      AND p_txt IS DISTINCT FROM new.p_txt;

    RETURN new;
  END $$ LANGUAGE plpgsql;
  --
  CREATE TRIGGER a_700_u__lieferscheinv__p_txt_to_rechnungv
   AFTER UPDATE
   OF p_txt
   ON TWawi.beleg_p__lieferscheinv
   FOR EACH ROW
   WHEN ( (TSystem.Settings__GetBool('bzUseArtTxt')) ) -- In Rechnung soll immer Text aus Artikelstamm genommen werden #8296
   EXECUTE PROCEDURE TWawi.beleg_p__lieferscheinv__a_700_u__p_txt_to_rechnungv();
 -- Eintragung DLZ
 CREATE OR REPLACE FUNCTION TWawi.beleg_p__lieferscheinv__a_700_iu__dlz() RETURNS TRIGGER AS $$
  DECLARE auftgbdat  DATE;
          bdea_first DATE;
  BEGIN
    IF new.plv_warenausgang_datum > -- Datum Warenausgang setzen bzw erhöhen
        COALESCE(
            (SELECT MAX(plv_warenausgang_datum)
                    FROM TWawi.beleg_p__lieferscheinv
                    WHERE plv_verkauf_p_id = new.plv_verkauf_p_id AND p_id <> new.p_id)
            , '2000-01-01'::DATE)
       THEN
        bdea_first = (SELECT min(ba_anf)::DATE FROM bdea WHERE ba_ix IN (
            SELECT DISTINCT tplanterm.get_all_child_abk(ld_abk) FROM ldsdok WHERE ld_ag_id = new.plv_verkauf_p_id));

        PERFORM -- Gsamtdurchlaufzeit (Bestelldatum bis Lieferschein, Tage) eintragen
           TRecnoParam.Set('auftg.dlz.Summe'    , auftg.dbrid, (new.plv_warenausgang_datum::date-ag_bdat   )::INTEGER),
           -- Fertigungszeit (1. Stempelung bis Lieferschein, Tage) eintragen
           TRecnoParam.Set('auftg.dlz.Fertigung', auftg.dbrid, (new.plv_warenausgang_datum::date-bdea_first)::INTEGER)
          FROM auftg WHERE ag_id = new.plv_verkauf_p_id;
    END IF;
    --
    RETURN new;
  END $$ LANGUAGE plpgsql;
  --
  CREATE TRIGGER a_700_iu__lieferscheinv__dlz -- TODO nur bei LOLL?
    AFTER INSERT OR UPDATE
    OF plv_warenausgang_datum
    ON TWawi.beleg_p__lieferscheinv
    FOR EACH ROW
    EXECUTE PROCEDURE TWawi.beleg_p__lieferscheinv__a_700_iu__dlz();
 -- Neue Lieferposition eingefuegt. Wenn die Verrechnungsfaehig und nicht gleich erledigt ist, muessen wir Fakturiert Status im Lieferdokument zuruecksetzen
 CREATE OR REPLACE FUNCTION TWawi.beleg_p__lieferscheinv__a_500_i__klv_fakturiert__reset() RETURNS TRIGGER AS $$
  BEGIN
    UPDATE TWawi.beleg_k__lieferscheinv SET klv_fakturiert = FALSE WHERE k_id = new.p_k_id AND klv_fakturiert;
    RETURN new;
  END $$ LANGUAGE plpgsql;
  --
  CREATE TRIGGER a_500_i__lieferscheinv__klv_fakturiert__reset
   AFTER INSERT
   ON TWawi.beleg_p__lieferscheinv
   FOR EACH ROW
   WHEN ((NOT new.p_storno) AND (NOT new.p_done))
   EXECUTE PROCEDURE TWawi.beleg_p__lieferscheinv__a_500_i__klv_fakturiert__reset();

-- TODO: Keywordsearch

--

-- Abzuschläge Existieren nicht bei Lieferschein

--

-- Views

-- Views Kompatibilität alte Lieferscheinviews. Public, da alte WawiViews & Reporting-Views darauf gehen

/* -- TODO update
 CREATE OR REPLACE FUNCTION TSystem.views__lieferscheinv__recreate() RETURNS VOID AS $$
  BEGIN
    CREATE OR REPLACE VIEW z_99_deprecated.lieferschein AS
     SELECT
       k_id_oldstructure,
       'LFS'::VARCHAR               AS beld_belegtyp,
       --Grundfelder,
       k_id                         AS beld_id,
       k_nummer                     AS beld_dokunr,
       k_erfasst_datum              AS beld_erstelldatum,
       k_kba_key                    AS beld_belegart,
       k_titel                      AS beld_titel,
       kx_refbeleg                  AS beld_refbeleg,
       k_txt_anschr                 AS beld_kopftext,
       k_txt_anschr_rtf             AS beld_kopftext_rtf,
       k_txt_schluss                AS beld_fusstext,
       k_txt_schluss_rtf            AS beld_fusstext_rtf,
       x_allgv1                     AS beld_allg1,
       x_allgv2                     AS beld_allg2,
                                    
       kx_ad_krzl                   AS beld_krzlieferung,
       k_ad_krz                     AS beld_krzbesteller,    -- Kunde Verkauf
       kx_ad_krzf                   AS beld_krzrechnung,
       k_apext_ap_krzl              AS beld_apkrzl,
       k_apext                      AS beld_ap,
       k_apint_db_usename1          AS beld_apint,
                                    
       --Statusinformationen,       
       k_definitiv                  AS beld_definitiv,                                
       k_print                      AS beld_print,
       klv_fakturiert               AS beld_verbucht,                                
    
       -- beld_exportdatum,         kx_buchdat?
                                    
       --, Versandinformationen     
       k_versand_v_id               AS beld_versandart,
       k_versand_bem                AS beld_versandartbem,
       k_versand_ort_adkrz          AS beld_versandort,
                                    
       kx_gewicht                   AS beld_gewicht,
       
       -- beld_vertragsnummer   VARCHAR(50),
       --, System
       dbrid,
       insert_date,
       insert_by,
       modified_by,
       modified_date
     FROM
     TWawi.beleg_k__lieferscheinv;
    
    
    
    CREATE OR REPLACE VIEW z_99_deprecated.lieferschein_pos AS -- ACHTUNG: sinnloserweise gibts den gleichen Viewnamen in TWawi, dort mit den Normierungen nach p_ Feldnamen(
     SELECT
       'LFS'::VARCHAR               AS belp_belegtyp,
       p_id_oldstructure,
       -- Grundfelder
       p_id                         AS belp_id,
       p_pos                        AS belp_pos,
       p_parent_pos                 AS belp_hauptpos,
       p_k_id                       AS belp_dokument_id,
       --                           
       p_ad_krz                     AS belp_krzbesteller,
       p_ad_krzf                    AS belp_krzrechnung,
       p_ad_krzl                    AS belp_krzlieferung,
       p_adress_referenz_nummer     AS belp_referenz,
    
       p_txt_int                     AS belp_txt,
       p_txt_int_rtf                 AS belp_txt_rtf,
       p_txt                         AS belp_dokutxt,
       p_txt_rtf                     AS belp_dokutxt_rtf,
                                     
       -- Warenbezug                 
       p_aknr                        AS belp_aknr,
       p_ak_bez                      AS belp_akbez,
       p_aknr_referenz               AS belp_referenzaknr,
       p_menge                       AS belp_menge,
       p_menge_gme                   AS belp_menge_gme,
       plv_mengef_gme 	             AS belp_menge_done_gme,
    
       me__menge_uf1__in__menge(p_me, plv_mengef_gme)
                                    AS belp_menge_done,
                                    
       p_me                         AS belp_mce,
       -- belp_los                  
       px_gewicht                   AS belp_gewicht,
    
       -- p_nbedarf AS belp_bestandsaktiv --aktuell nie in verwendung
       -- belp_versandart
       -- belp_versandartbem
    
    
       p_erfasst_datum              AS belp_erstelldatum,
       p_done                       AS belp_erledigt,
       p_storno                     AS belp_storniert,
                                    
       plv_warenausgang_datum       AS belp_termin,
       --px_l_iso                   AS belp_l_iso,
       px_an_nr                     AS belp_projektnummer,
                                    
       p_bstat1                     AS belp_bstat,
       p_bstat2                     AS belp_bstat1,
       p_bstat3                     AS belp_bstat2,
    
       -- Verknüpfungen
       plv_verkauf_p_id             AS belp_ag_id,
    
       belp_vorgaenger,
       belp_l_nr,
       belp_ab_ix,
       belp_a2_id,
       belp_q_nr,
    
       -- Kompatibilität alte / neue Belegstruktur. JOIN Fields für Delphi-SQL da mit ERG vermischt in einer Klasse
       NULL::VARCHAR                AS belp_kostenstelle,
       NULL::VARCHAR                AS belp_konto,
       NULL::INTEGER                AS belp_steucode,
       
       --System
       dbrid,
       insert_date,
       insert_by,
       modified_by,
       modified_date
     FROM
     TWawi.beleg_p__lieferscheinv;
            
  END $$ LANGUAGE plpgsql;
 
 CREATE OR REPLACE FUNCTION TSystem.views__beleg__recreate() RETURNS VOID AS $$ -- Todo auftrennen : eingrech
  BEGIN
      
    PERFORM  TSystem.views__lieferscheinv__recreate();  
    -- PERFORM  TSystem.views__rechnunge__recreate();
    
  END $$ LANGUAGE plpgsql;
        
 SELECT TSystem.views__beleg__drop();
 SELECT TSystem.views__beleg__recreate();
-- */
--
